package nfimage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

import nf.Config;

public class ImageConfig extends Config
{
	public String lastDir = new String();
	public void setLastDirFromFile(File f)
	{
		// Get the parent of this file
		lastDir = f.getParent();
	}
	@Override
	public void write(DataOutputStream dos) throws IOException
	{
		// Last directory opened
		dos.writeUTF(lastDir);
	}
	@Override
	public void read(DataInputStream dis) throws IOException
	{
		// Read in forcefully
		try
		{
			lastDir = dis.readUTF();
		}
		catch(IOException e){} // Ignore
	}
	@Override
	public String toString()
	{
		// Name of config
		return "nfimage";
	}
}