package nfimage;

import nf.Command;

/**
 * Image commands modify some subject that is a BlockImage.
 * @author Sayuri
 */
public abstract class ImageCommand extends Command
{
	protected static BlockImage subject;
	protected static ImageWindow window;
	protected static String autoFile;
	public static void setAutoFile(String s)
	{
		System.out.println("Auto file set to "+s);
		autoFile = s;
	}
	/**
	 * Changes the subject for the image commands to work on.
	 * @param bi The new block image to focus on
	 */
	public static void focus(BlockImage bi)
	{
		// Set
		subject = bi;
	}
	/**
	 * Changes the window the commands run in.
	 * @param iw The new window
	 */
	public static void window(ImageWindow iw)
	{
		// Set
		window = iw;
	}
}