package nfimage;

import java.awt.FlowLayout;

import nf.EntryBox;
import nf.ErrorBox;
import nf.NovaDialog;

public class FrameDialog extends NovaDialog
{
	private static final long serialVersionUID = 1L;
	private EntryBox wBox = new EntryBox("Width:");
	private EntryBox hBox = new EntryBox("Height:");
	int boundX,boundY;
	public FrameDialog()
	{
		setTitle("Frame Properties");
		setModal(true);
		// Create
		init();
		// Add some buttons
		setLayout(new FlowLayout());
		getContentPane().add(wBox);
		getContentPane().add(hBox);
		getContentPane().add(makeOKButton());
		getContentPane().add(makeCancelButton());
		pack();
	}
	public void setBounds(int bx,int by)
	{
		boundX = bx;
		boundY = by;
	}
	public void setValues(Integer x,Integer y)
	{
		// Transform to pixel values
		x *= 8;
		y *= 8;
		// Update
		wBox.setText(x.toString());
		hBox.setText(y.toString());
	}
	public int getFrameWidth()
	{
		return wBox.getInt()/8;
	}
	public int getFrameHeight()
	{
		return hBox.getInt()/8;
	}
	@Override
	public void invalid()
	{
		ErrorBox.show("Invalid frame values.");
	}
	@Override
	public boolean valid()
	{
		int tw,th;
		// Get
		tw = wBox.getInt();
		th = hBox.getInt();
		if(tw < 0 || th < 0)
			return false;
		// Reduce
		tw /= 8;
		th /= 8;
		// Both are zero
		if(tw == 0 && th == 0)
			return true;
		// One is zero
		if(tw == 0 && th != 0)
			return false;
		if(tw != 0 && th == 0)
			return false;
		// Out of bounds?
		if(tw > boundX)
			return false;
		if(th > boundY)
			return false;
		// Indivisible?
		if(boundX%tw != 0 || boundY%th != 0)
			return false;
		// It works
		return true;
	}
	@Override
	public void apply()
	{
		
	}
}