package nfimage;

import nf.ErrorBox;

public class FrameCommand extends ImageCommand
{
	private FrameDialog frameDialog = new FrameDialog();
	@Override
	public void run()
	{
		// No image yet?
		if(subject == null)
		{
			ErrorBox.show("No image loaded.");
			return;
		}
		// Set bounds and open
		frameDialog.setValues(subject.getFrameWidth(),subject.getFrameHeight());
		frameDialog.setBounds(subject.getWidth()/8,subject.getHeight()/8);
		frameDialog.open();
		// Set frames
		if(frameDialog.isApproved())
		{
			subject.setFrame(frameDialog.getFrameWidth(),frameDialog.getFrameHeight());
			window.repaint();
		}
	}
	@Override
	public String toString()
	{
		return "Frames";
	}
}