package nfimage;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

import javax.swing.JPanel;

import nf.ErrorBox;

/**
 * A block panel shows a BlockImage.
 * @author Sayuri
 */
public class BlockPanel extends JPanel implements ImageListener,MouseListener
{
	private static final long serialVersionUID = 1L;
	private BlockImage blockImage;
	private TransPanel transPanel;
	/**
	 * Create a new block display panel.
	 */
	public BlockPanel()
	{
		setBackground(Color.BLACK);
		setPreferredSize(new Dimension(400,300));
		addMouseListener(this);
	}
	/**
	 * Focus on a new BlockImage.
	 * @param bi The new block image
	 */
	public void focus(BlockImage bi,TransPanel tp)
	{
		// Set
		blockImage = bi;
		transPanel = tp;
		// Repaint
		repaint();
	}
	public BlockImage getFocus()
	{
		return blockImage;
	}
	@Override
	public void paintComponent(Graphics g)
	{
		// Paint super
		super.paintComponent(g);
		// Ignore if no image
		if(blockImage == null)
			return;
		// Paint image
		Graphics2D g2d = (Graphics2D)g;
		AffineTransform at = AffineTransform.getTranslateInstance(0,0);
		//at.scale(2,2);
		g2d.drawRenderedImage(blockImage.getImage(),at);
	}
	@Override
	public void imageChanged(BufferedImage bi)
	{
		// Repaint
		repaint();
	}
	@Override
	public void mouseClicked(MouseEvent e)
	{
		if(blockImage == null)
		{
			ErrorBox.show("No image loaded yet.");
			return;
		}
		// Set transcolor
		blockImage.setTransparentColor(e.getX(),e.getY());
		transPanel.setColor(blockImage.getTransparentColor());
		repaint();
	}
	@Override
	public void mousePressed(MouseEvent e){}
	@Override
	public void mouseReleased(MouseEvent e){}
	@Override
	public void mouseEntered(MouseEvent e){}
	@Override
	public void mouseExited(MouseEvent e){}
}