import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import junit.framework.Assert;
import nf.DataBlock;

import org.junit.Test;

public class TestDataBlock
{
	class TestData extends DataBlock
	{
		public int a,b;
		public int c,d;
		@Override
		public void write(DataOutputStream dos) throws IOException
		{
			writeInt(dos,a);
			writeInt(dos,b);
			writeNibble(dos,c);
			writeNibble(dos,d);
		}
		@Override
		public void read(DataInputStream dis) throws IOException
		{
			a = readInt(dis);
			b = readInt(dis);
			c = readNibble(dis);
			d = readNibble(dis);
		}
	}
	@Test
	public void testData() throws IOException
	{
		File tfile = new File("tfile.dat");
		TestData td = new TestData();
		td.a = 50;
		td.b = 250456;
		td.c = 9;
		td.d = 12;
		FileOutputStream fos = new FileOutputStream(tfile);
		DataOutputStream dos = new DataOutputStream(fos);
		td.write(dos);
		dos.close();
		fos.close();
		Assert.assertEquals(tfile.length(),9);
		TestData te = new TestData();
		FileInputStream fis = new FileInputStream(tfile);
		DataInputStream dis = new DataInputStream(fis);
		te.read(dis);
		dis.close();
		fis.close();
		Assert.assertEquals(te.a,50);
		Assert.assertEquals(te.b,250456);
		Assert.assertEquals(te.c,9);
		Assert.assertEquals(te.d,12);
		tfile.delete();
	}
}