package nf;

import java.io.IOException;

/**
 * A tool module may be indirect and integrated,
 * or direct and standalone.
 * @author Sayuri
 */
public abstract class ToolModule
{
	/**
	 * Starts the module as an integrated indirect tool.
	 * The filename given will be edited upon.
	 * @param filename The file to modify with this tool
	 */
	public abstract void indirect(String filename) throws IOException;
	/**
	 * Directly start the tool as a standalone program.
	 */
	public abstract void direct();
}