package nf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;

public abstract class NovaDialog extends JDialog
{
	private static final long serialVersionUID = 1L;
	private boolean approved;
	protected void attemptClose()
	{
		if(valid())
		{
			// Valid input, apply and close
			approved = true;
			apply();
			setVisible(false);
		}
		else
		{
			// Invalid input
			invalid();
		}
	}
	protected void attemptCancel()
	{
		// Just end
		setVisible(false);
	}
	protected JButton makeCancelButton()
	{
		// Make the cancel button
		JButton cb = new JButton("Cancel");
		cb.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				attemptCancel();
			}
		});
		return cb;
	}
	protected JButton makeOKButton()
	{
		// Make the OK button
		JButton cb = new JButton("OK");
		cb.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				// Attempts to approve changes
				attemptClose();
			}
		});
		return cb;
	}
	private class NovaAdapter extends WindowAdapter
	{
		@Override
		public void windowClosing(WindowEvent e)
		{
			// Close without applying changes
			attemptCancel();
		}
	}
	protected void init()
	{
		// Set properties
		setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
		addWindowListener(new NovaAdapter());
	}
	public boolean isApproved()
	{
		// User wants changes?
		return approved;
	}
	public void open()
	{
		// Open window
		approved = false;
		setLocationRelativeTo(null);
		setVisible(true);
	}
	public abstract boolean valid();
	public abstract void invalid();
	public abstract void apply();
}