package nf;

import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EntryBox extends JPanel
{
	private static final long serialVersionUID = 1L;
	private JTextField box = new JTextField();
	public EntryBox(String title,int wid)
	{
		// Set layout and build
		setLayout(new FlowLayout());
		add(new JLabel(title));
		box.setPreferredSize(new Dimension(wid,20));
		box.setSize(wid,20);
		add(box);
	}
	public EntryBox(String title)
	{
		// Set layout and build with default width
		this(title,64);
	}
	public void setText(String txt)
	{
		// Set
		box.setText(txt);
	}
	public String getText()
	{
		// Get
		return box.getText();
	}
	public int getInt()
	{
		// Parse and get
		try
		{
			return Integer.parseInt(box.getText());
		}
		catch(Exception e)
		{
			return -1;
		}
	}
}