package nf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JMenuItem;

/**
 * A command is a single command that modifies the model that is currently being editied.
 * @author Sayuri
 */
public abstract class Command implements ActionListener
{
	/**
	 * This method invokes the command.
	 */
	public abstract void run();
	/**
	 * Returns a menu item that, if clicked, will invoke this command.
	 * @return The created menu item that runs this command
	 */
	public JMenuItem makeMenuItem()
	{
		// Manufacture the menu item
		JMenuItem mi = new JMenuItem(toString());
		mi.addActionListener(this);
		return mi;
	}
	/**
	 * Returns a button that, if clicked, will invoke this command.
	 * @return The created button that will run this command
	 */
	public JButton makeButton()
	{
		JButton b = new JButton(toString());
		b.addActionListener(this);
		return b;
	}
	@Override
	public void actionPerformed(ActionEvent e)
	{
		// Run run
		run();
	}
}