#ifndef STAT_H
#define STAT_H

/* Amount of EXP needed to gain a star */
#define EXP_NEXT 160
/* Amount of levels needed in stats and total level for rank ups in titles */
#define RANK_UP 5
/* Amount of HP to add when increasing Health Total */
#define HP_ADD 8
/* Amount of EP to add when increasing Energy Total */
#define EP_ADD 4
/* Maximum amount of item slots the player can ever increase to */
#define MAX_CARRY 48
/* Maximum amount of items that may be equipped on the player at one time */
#define MAX_EQUIP 3
/* Maximum number of moves for the player to be able to learn */
#define MAX_MOVES 64
/* Maximum number of gem unlock event variables */
#define MAX_LEVEL_GEMS 256
/* Maximum number of event variables */
#define MAX_EVENT_VARS 512
/* Starting status number for all stats */
#define START_STAT 3
/* Initial backpack room */
#define START_CARRY 16

/* Player Status */
typedef struct
{
	u32 equip[3]; /* Player's equipment */
	u32 money; /* Amount of cash on the player */
	u16 health; /* Maximum amount of vitality */
	u16 energy; /* Maximum amount of energy */
	u16 hp; /* Current health */
	u16 ep; /* Current energy */
	u16 stars; /* Amount of stars */
	u16 level; /* Current level of stars (total stars earned) */
	u16 cleared; /* Number of stages cleared */
	u8 strength; /* Physical attack strength */
	u8 power; /* Ethereal power */
	u8 speed; /* Speed */
	u8 skill; /* Skills and critical hit rate */
	u8 exp; /* Amount of EXP 0-160 */
	u8 carry; /* Amount of backpack space the player has */
}stat_player;

/* Item Status */
typedef struct
{
	u32 itemid; /* ID of item */
	u32 itemamt; /* Amount of item */
}stat_inventory;

/* Move list */
typedef struct
{
	u8 level; /* Level of the move (0 for not learned yet) */
}stat_moves;

/* Unlocked gems */
typedef struct
{
	u8 unlocked; /* Has this gem been unlocked? */
}stat_gems;

/* Event vars */
typedef struct
{
	u8 ev; /* Event variable */
}stat_ev;

/*
	Resets all initial gameplay state data to its initial state.
	This prepares new games.
*/
extern void stat_init();

/*
	Saves current game data to save file.
*/
extern void stat_save();

/*
	Reads game data from file.
*/
extern void stat_load();

#endif
