/*
	Status
*/

/* Includes */
#include "novaforce.h"

/* Game state */
EWRAM_DATA stat_player player;
EWRAM_DATA stat_inventory items[MAX_CARRY];
EWRAM_DATA stat_moves moves[MAX_MOVES];
EWRAM_DATA stat_gems gems[MAX_LEVEL_GEMS];
EWRAM_DATA stat_ev evs[MAX_EVENT_VARS];

/* Initial game stat */
void stat_init()
{
	/* Zero out all fields */
	mem_set(&player,0,sizeof(player));
	mem_set(items,0,sizeof(items));
	mem_set(moves,0,sizeof(moves));
	mem_set(gems,0,sizeof(gems));
	mem_set(evs,0,sizeof(evs));
	/* Set fields that are non-zero at initial state */
	player.health = 10;
	player.hp = 10;
	player.energy = 6;
	player.ep = 6;
	player.strength = START_STAT;
	player.power = START_STAT;
	player.speed = START_STAT;
	player.skill = START_STAT;
	player.carry = START_CARRY;
}

/* Save all game data */
void stat_save()
{
	/* Open */
	mem_open(0);
	/* Save all fields */
	mem_write(&player,sizeof(player));
	mem_write(items,sizeof(items));
	mem_write(moves,sizeof(moves));
	mem_write(gems,sizeof(gems));
	mem_write(evs,sizeof(evs));
	/* Close */
	mem_close();
}

/* Read all game data */
void stat_load()
{
	/* Open */
	mem_open(0);
	/* Read all fields */
	mem_read(&player);
	mem_read(items);
	mem_read(moves);
	mem_read(gems);
	mem_read(evs);
	/* Close */
	mem_close();
}
