#ifndef NOVAFORCE_H
#define NOVAFORCE_H

/* Current platform */
#define GBA

/* Code locations for the GBA */
#ifdef GBA
#define IWRAM_CODE	__attribute__((section(".iwram"), long_call))
#define EWRAM_CODE	__attribute__((section(".ewram"), long_call))
#define IWRAM_DATA	__attribute__((section(".iwram")))
#define EWRAM_DATA	__attribute__((section(".ewram")))
#endif

/* Elementary typedefs */
typedef volatile unsigned short vu16;
typedef volatile unsigned long vu32;
typedef unsigned long u32;
typedef unsigned short u16;
typedef unsigned char u8;

/* Modules */
#include "mem.h"
#include "stat.h"
#include "video.h"
#include "sys.h"
#include "maps.h"

#endif
