#ifndef MEM_H
#define MEM_H

/* DMA3 */
#define DMA3_SRC	*((vu32*)0x040000D4)
#define DMA3_DEST	*((vu32*)0x040000D8)
#define DMA3_COUNT	*((vu16*)0x040000DC)
#define DMA3_CNT	*((vu16*)0x040000DE)

/* SRAM / PAK */
#define WAITCNT		*((vu16*)0x04000204)

/*
	Copies data 32-bits at a time (length must be a multiple of 4 bytes)
	from the source pointer to the destination pointer.
*/
extern void mem_copy(void *src,void *dest,u32 len);

/*
	Sets a 32-bit value for a range of memory set by destination and length.
	Behaves like memset only for 32-bits at a time.
*/
extern void mem_set(void *dest,u32 val,u32 len);

/*
	Opens a channel to the gamesave file at offset given (in bytes).
*/
extern void mem_open(u32 loc);

/*
	Closes the channel to the gamesave file.
*/
extern void mem_close();

/*
	Writes the contents referenced by src to save file.
	len is the number of bytes to write.
*/
extern void mem_write(void *src,u32 len);

/*
	Reads the contents referenced by dst from save file.
	len is derived from an actual value inside the save file.
*/
extern void mem_read(void *dst);

#endif
