/*
	Memory
*/

/* Includes */
#include "novaforce.h"

/* Globals */
u8 *sram_ptr;

/* Prototypes */
void mem_copy(void *src,void *dest,u32 len);
void mem_set(void *dest,u32 val,u32 len);
void mem_open(u32 loc);
void mem_close();

/* Drivers */
#ifdef GBA
#include "_gbamem.h"
#endif

/* Write to save file */
void mem_write_byte(u8 x)
{
	/* Write out to pointer */
	*sram_ptr = x;
	/* Advance */
	sram_ptr++;
}

/* Read from save file */
EWRAM_CODE u8 mem_read_byte()
{
	u8 r;
	/* Get from pointer */
	r = *sram_ptr;
	/* Advance */
	sram_ptr++;
	/* Return */
	return r;
}

/* Read length from save file */
u32 mem_read_len()
{
	u32 r;
	u32 i;
	u8 *dst_ptr;
	/* Get pointer */
	dst_ptr = (u8*)&r;
	/* Read all 4 */
	for(i = 0;i < 4;i++)
	{
		*dst_ptr = mem_read_byte();
		dst_ptr++;
	}
	/* Return it */
	return r;
}

/* Write length to save file */
void mem_write_len(u32 len)
{
	u8 *src_ptr;
	u32 i;
	/* Get pointer */
	src_ptr = (u8*)&len;
	/* Write all 4 */
	for(i = 0;i < 4;i++)
	{
		mem_write_byte(*src_ptr);
		src_ptr++;
	}
}

/* Writes out the contents of the pointer */
void mem_write(void *src,u32 len)
{
	u8 *src_ptr;
	/* Begin writing the bytes */
	src_ptr = (u8*)src;
	/* First, write the length of the upcoming segment */
	mem_write_len(len);
	/* Write fully (while remaining length is not zero) */
	while(len)
	{
		/* Write the byte */
		mem_write_byte(*src_ptr);
		/* Increase the source pointer */
		src_ptr++;
		/* Reduce length by 1 */
		len--;
	}
}

/* Reads the contents into the pointer, length is in file data */
void mem_read(void *dst)
{
	u8 *dst_ptr;
	u32 len;
	/* Begin reading the bytes */
	dst_ptr = (u8*)dst;
	/* First, read the length */
	len = mem_read_len();
	/* Read fully (while remaining length is not zero) */
	while(len)
	{
		/* Read the byte */
		*dst_ptr = mem_read_byte();
		/* Increase the dest pointer */
		dst_ptr++;
		/* Reduce length by 1 */
		len--;
	}
}
