/*
	Level Maps
*/

/* Includes */
#include "novaforce.h"

/* Globals */
u32 fragment_width;
u32 fragment_height;
u32 fragment_size;
u32 *lower_map;
u32 *upper_map;

/* Gets a fragment on the map */
u32 map_get(u32 layer,u32 x,u32 y)
{
	/* Out of bounds? */
	if(x >= fragment_width || y >= fragment_height)
		fatal_exception("MAP","OUT OF BOUND FRAGMENT");
	/* Lower layer? */
	if(layer == NFM_LOWER)
		return lower_map[x+y*fragment_width];
	/* Upper layer? */
	if(layer == NFM_UPPER)
		return upper_map[x+y*fragment_width];
	/* Error */
	fatal_exception("MAP","INVALID FRAGMENT LAYER");
	return 0;
}

/* Gets a fragment on the map and then sets it on the VRAM */
void map_copy_fragment(u32 layer,u32 sx,u32 sy,u32 dx,u32 dy)
{
	u32 frag;
	/* Validate input */
	if(dx >= 32 || dy >= 32)
		fatal_exception("MAP","OUT OF BOUND VRAM");
	/* Get a fragment */
		frag = map_get(layer,sx,sy);
	/* Lower layer transfer? */
	if(layer == NFM_LOWER)
		BG_BASE[dx+(dy<<5)] = frag; /* Place a fragment */
	/* Upper layer transfer? */
	if(layer == NFM_UPPER)
	{
		BG_BASE[0x400+dx+(dy<<5)] = frag; /* Place a fragment */
		BG_BASE[0x800+dx+(dy<<5)] = 798; /* Place a fragment */
	}
}

/* Copies the initial map at 0,0 */
void map_initial()
{
	u32 w,h;
	u32 x,y;
	/* Get sizes */
	if(fragment_width > 32)
		w = 32;
	else
		w = fragment_width;
	if(fragment_height > 32)
		h = 32;
	else
		h = fragment_height;
	/* Then copy */
	for(y = 0;y < h;y++)
	{
		for(x = 0;x < w;x++)
		{
			map_copy_fragment(NFM_LOWER,x,y,x,y);
			map_copy_fragment(NFM_UPPER,x,y,x,y);
		}
	}
}

/* Loads a new map */
void map_load(void *mapsrc)
{
	u32 *base;
	/* Get width and height */
	base = (u32*)mapsrc;
	fragment_width = base[0]<<1;
	fragment_height = base[1]<<1;
	fragment_size = fragment_width*fragment_height;
	/* Reference the layers */
	lower_map = base+2;
	upper_map = lower_map+fragment_size;
	/* Set initial */
	map_initial();
}
