/* Wait for the vblank / whatever */
void video_wait()
{
	/* Wait for vertical blanking */
	while(!DISPSTAT&1);
}

/* Wipe out video settings */
void video_wipe()
{	
	/* Erase entire VRAM */
	mem_set(VRAM,0,98304);
	/* Reset display control to nothing */
	DISPCNT = (1<<7);
}

/* Enter typical mapping mode */
void video_init()
{
	/* Wipe */
	video_wipe();
	/* Set all the background layer settings */
	BG0_CNT = (3)+(24<<8);
	BG1_CNT = (2)+(25<<8);
	BG2_CNT = (1)+(26<<8);
	BG3_CNT = (2<<2)+(27<<8);
	/* Set the video mode */
	DISPCNT = (1<<6)+(1<<8)+(1<<9)+(1<<10)+(1<<11)+(1<<12); /* Layers 1234 and Object on, normal video mode */
}

/* Loads an NFI image into the VRAM offset given */
void video_image_load(u32 voff,u32 poff,u32 plen,void *imgsrc)
{
	nfi_header *nfih;
	u32 *npal;
	u32 *nimg;
	u32 len;
	/* Verify input */
	if(voff >= 98304)
		fatal_exception("VIDEO","IMAGE VRAM OFFSET INVALID");
	if(poff >= 16)
		fatal_exception("VIDEO","PALETTE OFFSET INVALID");
	if(plen > 256)
		fatal_exception("VIDEO","PALETTE LENGTH INVALID");
	/* Map header */
	nfih = (nfi_header*)imgsrc;
	/* Calculate the number of blocks to copy */
	len = nfih->width*nfih->height;
	/* Multiply the blocks with the size per block */
	len = (len<<(5+nfih->type));
	/* Map palette */
	npal = (u32*)imgsrc;
	npal += sizeof(nfi_header)>>2;
	/* Map image */
	nimg = (u32*)npal;
	if(nfih->type == NFI_256)
		nimg += 128;
	else
		nimg += 8;
	/* Load the palette */
	mem_copy(npal,&VPAL[poff<<5],plen<<1);
	/* Load the picture */
	mem_copy(nimg,&VRAM[voff],len);
}

/* Loads an NFT into the VRAM */
void video_tileset_load(void *imgsrc)
{
	u32 *tpal;
	u32 *timg;
	u32 *tmeta;
	/* Reference the palette */
	tpal = (u32*)imgsrc;
	/* Reference the image */
	timg = tpal+96;
	tmeta = timg+8192;
	/* Load the palette */
	mem_copy(tpal,VPAL,384);
	/* Load the image */
	mem_copy(timg,VRAM,32768);
	/* Set the pointers */
	tileset_color = tmeta;
	tileset_pass = tileset_color+256;
	tileset_type = tileset_pass+256;
	tileset_layer = tileset_type+256;
}
