/* Resource for the horrible font */
extern u32 system_font[];

/* Prints the text on fatal errors */
void fatal_print(u32 x,u32 y,char *str)
{
	u32 cx,cy;
	/* Set cursor */
	cx = x;
	cy = y;
	/* While no null */
	while(*str)
	{
		/* Putc */
		BG_BASE[cx+(cy<<5)] = (*str-32);
		/* Return? */
		if(*str == '\n')
		{
			/* Hit enter */
			cx = x;
			cy++;
		}
		else
		{
			/* Increment */
			cx++;
		}
		/* Advance */
		str++;
	}
}

/* Traps into error reporting with a red screen of death */
void fatal_error()
{
	/* Immediatly destroy the screen and set it to red */
	video_wipe();
	DISPCNT = (1<<8);
	VPAL[0] = 31;
	/* Now, load the font */
	video_image_load(0,0,16,system_font);
	/* Print the message */
	fatal_print(0,0,"FATAL EXCEPTION");
	fatal_print(0,1,"IN:");
	fatal_print(4,1,error_section);
	fatal_print(0,3,error_message);
	/* Jam the processor */
	while(1);
}
