/* Memory copy */
void mem_copy(void *src,void *dest,u32 len)
{
	/* Set the source and destinations */
	DMA3_SRC = (u32)src;
	DMA3_DEST = (u32)dest;
	/* Configure and run */
	DMA3_COUNT = (len>>2);
	DMA3_CNT = (1<<10)+(1<<15);
}

/* Memory set */
void mem_set(void *dest,u32 val,u32 len)
{
	/* Set the source and destinations */
	DMA3_SRC = (u32)&val;
	DMA3_DEST = (u32)dest;
	/* Configure and run */
	DMA3_COUNT = (len>>2);
	DMA3_CNT = (2<<7)+(1<<10)+(1<<15);
}

/* Open channel to save system */
void mem_open(u32 loc)
{
	/* Set wait state */
	WAITCNT = 3;
	/* Set pointer */
	sram_ptr = ((u8*)0x0E000000+loc);
}

/* Close channel to save system */
void mem_close()
{
	/* Reset wait state */
	WAITCNT = 0;
}
