#ifndef GBAIMG_H
#define GBAIMG_H

/* Defines */
#define IMAGE_INDEX_MODEL 0
#define IMAGE_FULL_COLOR_MODEL 1

/* Color */
typedef struct
{
	unsigned char blue;
	unsigned char green;
	unsigned char red;
}color;

/* Image */
typedef struct
{
	/* Size */
	int w,h;
	int model;
	/* Palette */
	color *palette;
	unsigned char *data;
	color *cdata;
}image;

/*
	Loads the image from a bitmap into memory.
*/
extern int gbaimg_load(image *img,char *filename);

/*
	Release the image from memory.
*/
extern void gbaimg_free(image *img);

/*
	Returns the name string of a color model.
*/
extern char *gbaimg_name(int model);

#endif
