/*
	Image Converter
*/

/* Includes */
#include "gbaconv.h"
#include "gbaexp.h"

/* Returns the mode code for a bpp request */
int gbaconv_bpp_mode(int bpp)
{
	/* Convert */
	if(bpp == 4)
		return METHOD_4;
	if(bpp == 8)
		return METHOD_8;
	if(bpp == 16)
		return METHOD_16;
	/* Error */
	return -1;
}

/* Process the conversion */
int gbaconv_run(image *img,int smode,int targbpp)
{
	/* Return the corresponding mode code */
	if(targbpp != -1)
		return gbaconv_bpp_mode(targbpp);
	/* 1-1 */
	return smode;
}
